package com.hhwebservice.utils.file;

/**
 * Methoden zur Manipulation und Verarbeitung von DataHandlern.
 */

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;


public class DataConverter 
{
	public static final String BYTEARRAY = "application/octet-stream";
	
    /**
     * Erstellt aus einer Datei ein java.awt.Image.
     */	    
	public static Image toImage(String filename) 
	throws IOException 
	{
		return ImageIO.read(new FileInputStream(filename));
	}	
	
    /**
     * Erstellt aus binren Daten ein java.awt.Image.
     */	
    public static Image toImage(byte[] data) 
    throws IOException
    {
    	return ImageIO.read(new ByteArrayInputStream(data));
    }

    /**
     * Erstellt aus einem DataHandler ein java.awt.Image.
     */    
    public static Image toImage(DataHandler handler) 
    throws IOException
    {
    	ByteArrayDataSource datasource = (ByteArrayDataSource)handler.getDataSource();
    	return ImageIO.read(datasource.getInputStream());
    }    
    
    /**
     * Speichert ein java.awt.Image auf Festplatte.
     */    
	public static void writeImage(BufferedImage image, String filename) 
	throws IOException 
	{
       Iterator<ImageWriter> itty = ImageIO.getImageWritersBySuffix("jpeg");
	   if (itty.hasNext()) 
	   {
	        ImageWriter iw = (ImageWriter) itty.next();

	        ImageWriteParam iwp = iw.getDefaultWriteParam();
	        iwp.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
	        iwp.setCompressionQuality(0.95f);

	        ImageOutputStream ios = ImageIO.createImageOutputStream(new File(filename));

	        iw.setOutput(ios);
	        iw.write(null,new IIOImage(image,null,null),iwp);
	        ios.close();
	   }
	} 
    
    /**
     * Speichert den Inhalt einer Datei als binre Daten.
     */	
    public static byte[] toByteArray(String filename)
    throws Exception
    {
        return FileUtils.readBytes(new File(filename));
    }        
    
    /**
     * Speichert den Inhalt eines java.awt.image als binre Daten.
     */    
    public static byte[] toByteArray(BufferedImage image) 
    throws IOException 
    {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write(image, "jpeg", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
          
    /**
     * Speichert den Inhalt einer Datei als binre Daten.
     */    
    public static byte[] toByteArray(File file) 
    throws Exception, FileNotFoundException 
    {
        InputStream fileIn = new FileInputStream(file);    	
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(fileIn, byteArrayOutputStream, true);
        fileIn.close();
        return byteArrayOutputStream.toByteArray();
    }          
    
    /**
     * Speichert den Inhalt eines Datahandlers als binre Daten.
     */    
    public static byte[] toByteArray(DataHandler handler) 
    throws IOException
    {   	
        InputStream mtomIn = handler.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.copy(mtomIn, out, true);
        mtomIn.close();
        return out.toByteArray();
    }
    
    /**
     * Speichert den Inhalt einer Datei als Datahandler.
     */    
    public static DataHandler toHandler(String filename)
    {
    	return new DataHandler(new FileDataSource(filename));
    }
    
    /**
     * Speichert binre Daten als Datahandler.
     */     
    public static DataHandler toHandler(byte[] array)
    {    	
    	ByteArrayDataSource datasource = new ByteArrayDataSource(array, BYTEARRAY);
    	return new DataHandler(datasource);  
    }
    
    /**
     * Speichert den Inhalt eines java.awt.image als Datahandler.
     */     
    public static DataHandler toHandler(BufferedImage image) 
    throws IOException
    {    	
    	return new DataHandler(new ByteArrayDataSource(toByteArray(image), BYTEARRAY));  
    }    
    
    /**
     * Speichert den Inhalt eines Datahandlers auf Festplatte.
     */     
    public static void writeDataHandler(DataHandler handler, String filename) 
    throws IOException
    {
    	byte[] bytearray = toByteArray(handler);
    	if (bytearray != null && bytearray.length > 0)
    	{
    		FileUtils.writeBytes(new File(filename), bytearray);
    	}
    }
    
        
    
}
